/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.domain;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Domain {
    private static final String TRACE_MASKT = "XFRMDOMT";
    private static final String TRACE_MASKF = "XFRMDOMF";
    private static final String TRACE_MASKD = "XFRMDMOD";
    private DomainIdentifier did = new DomainIdentifier("");
    private Set participants = new HashSet();

    public Domain() {
    }

    public Domain(DomainIdentifier did) {
        this(did, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain(DomainIdentifier did, Set participants) {
        this.setDomainId(did);
        if (participants != null && !participants.isEmpty()) {
            Set set = this.participants;
            synchronized (set) {
                this.participants.addAll(participants);
            }
        }
    }

    public DomainIdentifier getDomainId() {
        return this.did;
    }

    public void setDomainId(DomainIdentifier did) {
        this.did = did;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(Object participant) throws HException {
        Set set = this.participants;
        synchronized (set) {
            this.participants.add(participant);
        }
    }

    public void addParticipants(Set partSet) throws HException {
        if (partSet == null || partSet.isEmpty()) {
            return;
        }
        Iterator partIter = partSet.iterator();
        while (partIter.hasNext()) {
            this.addParticipant(partIter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipant(Object participant) {
        Set set = this.participants;
        synchronized (set) {
            this.participants.remove(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getParticipants() {
        Set set = this.participants;
        synchronized (set) {
            return (Set)((HashSet)this.participants).clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasParticipants() {
        Set set = this.participants;
        synchronized (set) {
            return this.participants != null && !this.participants.isEmpty();
        }
    }

    public Set buildDomainInstances() {
        Trace.trace(TRACE_MASKD, "--> buildDomainInstances");
        Set instanceSet = this.instantiateDomains();
        if (instanceSet != null && !instanceSet.isEmpty()) {
            Iterator instanceIter = instanceSet.iterator();
            Domain domInstance = null;
            while (instanceIter.hasNext()) {
                domInstance = (Domain)instanceIter.next();
                domInstance.initialize();
            }
        }
        Trace.trace(TRACE_MASKD, "<-- buildDomainInstances");
        return instanceSet;
    }

    protected Set instantiateDomains() {
        RuntimeException rte = new RuntimeException("Domain.instantiateDomains() superclass method should not be invoked");
        Trace.trace(TRACE_MASKD, "<-> instantiateDomains: Invalid method call");
        Trace.trace(TRACE_MASKD, rte);
        throw rte;
    }

    protected void initialize() {
        DomainManager.getDomainManager().put(this);
    }

    public void remove() {
        DomainManager.getDomainManager().put(this);
    }

    protected String getDomainTrace(String trace) {
        return "[" + this.getDomainId().getDID() + "] " + trace;
    }
}

